/*
 * Decompiled with CFR 0.152.
 */
package bird.util;

public class CircBuf {
    public static final int BUFF_ERR = -1;
    private byte[] buf_;
    private int i_tail_;
    private int i_head_;
    private int length_;
    private int size_;

    public CircBuf(int n) {
        this.buf_ = new byte[n];
        this.size_ = n;
        this.length_ = 0;
        this.i_tail_ = 0;
        this.i_head_ = 0;
        for (int i = 0; i < this.size_; ++i) {
            this.buf_[i] = 0;
        }
    }

    public synchronized int addElements(byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            this.push(byArray[i]);
        }
        return Math.min(n, this.size_);
    }

    public synchronized void pushElement(byte by) {
        this.push(by);
    }

    public synchronized int getElements(byte[] byArray, int n) {
        int n2 = Math.min(n, this.length_);
        for (int i = 0; i < n2; ++i) {
            byArray[i] = this.pop();
        }
        return n2;
    }

    public synchronized byte popElement() {
        return this.pop();
    }

    public synchronized byte peekFront() {
        return this.buf_[this.i_head_];
    }

    public synchronized byte peekAt(int n) {
        if (n < 0 || n >= this.length_) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.i_head_;
        for (int i = 0; i < n; ++i) {
            n2 = this.incIndex(n2, this.size_);
        }
        return this.buf_[n2];
    }

    public synchronized void clear(boolean bl, int n) {
        if (bl) {
            for (int i = 0; i < this.size_; ++i) {
                this.buf_[i] = 0;
            }
            this.length_ = 0;
            this.i_tail_ = 0;
            this.i_head_ = 0;
        } else {
            int n2 = Math.min(n, this.length_);
            for (int i = 0; i < n2; ++i) {
                this.pop();
            }
        }
    }

    public synchronized int getLength() {
        return this.length_;
    }

    public synchronized int getSize() {
        return this.size_;
    }

    public synchronized int findElement(byte by) {
        int n = -1;
        try {
            int n2 = this.i_head_;
            for (int i = 0; i < this.length_; ++i) {
                if (by == this.buf_[n2]) {
                    n = i;
                    break;
                }
                n2 = this.incIndex(n2, this.size_);
            }
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }

    protected void push(byte by) {
        if (this.length_ == this.size_) {
            this.pop();
        }
        this.buf_[this.i_tail_] = by;
        if (this.length_ < this.size_) {
            ++this.length_;
        }
        this.i_tail_ = this.incIndex(this.i_tail_, this.size_);
    }

    protected byte pop() {
        byte by = this.buf_[this.i_head_];
        this.buf_[this.i_head_] = 0;
        this.i_head_ = this.incIndex(this.i_head_, this.size_);
        if (this.length_ > 0) {
            --this.length_;
        }
        if (this.length_ == 0) {
            this.i_tail_ = 0;
            this.i_head_ = 0;
        }
        return by;
    }

    private int incIndex(int n, int n2) {
        return n + 1 < n2 ? n + 1 : 0;
    }
}

